format long;

clear all;
close all;

tic;

%%   parameters and definitions

filename = 'opt_sim';

model = mphload(filename);
load(filename);

Eval_mech.CentralFrequency = 333e6;
Eval_mech.NumberOfFrequencies = 45;

% Path along the k-space
Eval_mech.res = 30;
Eval_mech.kx = linspace(0, pi/(geom.mech.amech)/2, Eval_mech.res);
Eval_mech.ky = linspace(0, pi/(geom.mech.amech)*sqrt(3)/2, Eval_mech.res);
Eval_mech.bands = zeros(Eval_mech.NumberOfFrequencies,size(Eval_mech.kx, 2));
Eval_mech.g0 = zeros(Eval_mech.NumberOfFrequencies,size(Eval_mech.kx,2));

% Get boundary and volume elements for OM coupling calculation
entities = get_entities(geom, model); % Surface and volume entities

% Optical mode index and frequency
optSol.number = Eval_opt.index;
optSol.freq = Eval_opt.frequency;

% .mph and .mat output files
% the scripts were run 3 times for different parts, where 
% part1 contains k indices from 1 to 10
% part2 contains k indices from 11 to 20
% part3 contains k indices from 21 to 30
% Finally (not a part of this script), we combine the data values from all 
% the 3 .mat files to a single .mat file
Eval_mech.filename = strcat(filename, '_part2');

%% COMSOL STUDY

disp('Launching mechanics study... ');
study = model.study.create('std2');
studyEf = study.feature.create('eig', 'Eigenfrequency');
studyEf.activate('emw', false);
studyEf.activate('solid', true);
studyEf.set('neigs', num2str(Eval_mech.NumberOfFrequencies));
studyEf.set('shift', num2str(Eval_mech.CentralFrequency));

% Link optics solution
studyEf.set('usesol', true);
studyEf.set('notsolmethod', 'sol');
studyEf.set('notstudy', 'std');
studyEf.set('notsolnum', 'from_list');
studyEf.set('notlistsolnum', [Eval_opt.index]);

for i=11:20
    disp( ['Iteration: ',num2str(i),'/',num2str(size(Eval_mech.kx,2))]  )
    model.physics('solid').feature('pc1').set('kFloquet', ...
        {num2str(Eval_mech.kx(i),'%10.9e') ...
        num2str(Eval_mech.ky(i),'%10.9e') '0'});
    study.run;
    data = mpheval(model,'freq','selection',1,'edim',...
        'point','dataonly','on','dataset','dset2');
    
    Eval_mech.bands(:,i) = data;
    
    % OM coupling
    mechSol = 1:Eval_mech.NumberOfFrequencies;
%     mechSol = find(data > Eval_mech.low_freq & ...
%         data < Eval_mech.high_freq);

    [model, Eval_mech.g0(mechSol,i)] = ...
                om_coupling(model, entities, ...
                optSol, mechSol);
    
    save(Eval_mech.filename, 'Eval_mech', 'Eval_opt', 'geom');

    if i>=15 && i<=19
        filename1 = strcat(Eval_mech.filename,num2str(i));
        mphsave(model, filename1);
    end
end

Eval_mech.time = toc;

save(Eval_mech.filename, 'Eval_mech', 'Eval_opt', 'geom');